/*************Headers**************/
#include	"config.h"
#include	"usart.h"
#include	"PCA.h"
#include	"timer.h"
#include	"adc.h"
#include	"delay.h"
#include	"string.h"
#include	"stdlib.h"

/*************	Functions	**************

Receive messages using interrupt. 


******************************************/
//IO pins and GL-Moto-Mini

//P2.2 router power. Because of no voltage detection, this should be always on

//P2.5 P2.6 P2.7 is used to output 3 channel PWMP2.5->PWM3 P2.6->PWM2  P2.7->PWM1

//P3.0P3.1 is used for MCU programming

//P3.6P3.7 is used for MCU CPU communications

//LED4 is controlled by P1.1

//LED0LED1LED2 is connected to CPU's LED0LED1LED2
//


/*************	PAC_PWM	 **************/
u16	 pwm0,pwm1,pwm2;
/*************	TIME_PWM **************/
u16	pwm;			                  //PWM high duration
/*************	UART	 **************/
char *delim = ",";
char *message_p[4]={NULL};
int  message_data[4]={1500,1500,1500,1500};// init value of 4 channels message_data[0] for steeringmessage_data[1] speed
u16  communicate_time = 0;  //Interrupt flag, it add 1 each time. When communicated, it will be reset to 0. If the value is more than 500, it will be regarded as communication broken



/*************  UART 1 init *****************/
void	UART_config(void)
{
	COMx_InitDefine		COMx_InitStructure;					//struct
	COMx_InitStructure.UART_Mode      = UART_8bit_BRTx;		//mode:      UART_ShiftRight,UART_8bit_BRTx,UART_9bit,UART_9bit_BRTx
	COMx_InitStructure.UART_BRT_Use   = BRT_Timer2;			//use baudrate rate   BRT_Timer1, BRT_Timer2 (attention: UART2 uses BRT_Timer2)
	COMx_InitStructure.UART_BaudRate  = 115200ul;			//baudrate 110 ~ 115200
	COMx_InitStructure.UART_RxEnable  = ENABLE;				//enable Rx,   ENABLEDISABLE
	COMx_InitStructure.BaudRateDouble = DISABLE;			//baudrateDouble ENABLEDISABLE
	COMx_InitStructure.UART_Interrupt = ENABLE;				//Interrupt enable ENABLEDISABLE
	COMx_InitStructure.UART_Polity    = PolityLow;			//Interrupt priority PolityLow,PolityHigh
#ifdef VBATT_DEBUG
	COMx_InitStructure.UART_P_SW      = UART1_SW_P30_P31;
#else
	COMx_InitStructure.UART_P_SW      = UART1_SW_P36_P37;	//change port  UART1_SW_P30_P31,UART1_SW_P36_P37,UART1_SW_P16_P17(must use internal timer)
#endif
	COMx_InitStructure.UART_RXD_TXD_Short = DISABLE;		//short RXD and TXD,  ENABLE,DISABLE
	USART_Configuration(USART1, &COMx_InitStructure);		//init UART1 USART1,USART2
	PrintString1("STC15F2K60S2 UART1 Test Prgramme!\r\n");	//send test message to SUART1
}


/*************  PCA_PWM Init *****************/
void	PCA_config(void)
{
	PCA_InitTypeDef		PCA_InitStructure;

	PCA_InitStructure.PCA_Clock    = PCA_Clock_12T;		            //PCA_Clock_1T, PCA_Clock_2T, PCA_Clock_4T, PCA_Clock_6T, PCA_Clock_8T, PCA_Clock_12T, PCA_Clock_Timer0_OF, PCA_Clock_ECI
	PCA_InitStructure.PCA_IoUse    = PCA_P24_P25_P26_P27; 	        //PCA_P12_P11_P10_P37, PCA_P34_P35_P36_P37, PCA_P24_P25_P26_P27
	PCA_InitStructure.PCA_Interrupt_Mode = DISABLE;		            //ENABLE, DISABLE
	PCA_InitStructure.PCA_Polity   = PolityHigh;			        //priority setting	PolityHigh,PolityLow
	PCA_InitStructure.PCA_RUN      = DISABLE;			            //ENABLE, DISABLE
	PCA_Init(PCA_Counter,&PCA_InitStructure);

	PCA_InitStructure.PCA_Mode     = PCA_Mode_HighPulseOutput;		//PCA_Mode_PWM, PCA_Mode_Capture, PCA_Mode_SoftTimer, PCA_Mode_HighPulseOutput
	PCA_InitStructure.PCA_PWM_Wide = 0;					            //PCA_PWM_8bit, PCA_PWM_7bit, PCA_PWM_6bit
	PCA_InitStructure.PCA_Interrupt_Mode = ENABLE;		            //PCA_Rise_Active, PCA_Fall_Active, ENABLE, DISABLE
	PCA_InitStructure.PCA_Value    = 65535;			                //software timer
	PCA_Init(PCA0,&PCA_InitStructure);

	PCA_InitStructure.PCA_Mode     = PCA_Mode_HighPulseOutput;		//PCA_Mode_PWM, PCA_Mode_Capture, PCA_Mode_SoftTimer, PCA_Mode_HighPulseOutput
	PCA_InitStructure.PCA_PWM_Wide = 0;					            //PCA_PWM_8bit, PCA_PWM_7bit, PCA_PWM_6bit
	PCA_InitStructure.PCA_Interrupt_Mode = ENABLE;		            //PCA_Rise_Active, PCA_Fall_Active, ENABLE, DISABLE
	PCA_InitStructure.PCA_Value    = 65535;				            //software timer
	PCA_Init(PCA1,&PCA_InitStructure);

	PCA_InitStructure.PCA_Mode     = PCA_Mode_HighPulseOutput;		//PCA_Mode_PWM, PCA_Mode_Capture, PCA_Mode_SoftTimer, PCA_Mode_HighPulseOutput
	PCA_InitStructure.PCA_PWM_Wide = 0;					            //PCA_PWM_8bit, PCA_PWM_7bit, PCA_PWM_6bit
	PCA_InitStructure.PCA_Interrupt_Mode = ENABLE;		            //PCA_Rise_Active, PCA_Fall_Active, ENABLE, DISABLE
	PCA_InitStructure.PCA_Value    = 65535;				            //software timer
	PCA_Init(PCA2,&PCA_InitStructure);


}

/************************ Timer ****************************/
void	Timer_config(void)
{
	//Set the IO to output, then change its duty cycle
	TIM_InitTypeDef		TIM_InitStructure;					//init struct
	TIM_InitStructure.TIM_Mode      = TIM_16BitAutoReload;	//working mode  TIM_16BitAutoReload,TIM_16Bit,TIM_8BitAutoReload,TIM_16BitAutoReloadNoMask
	TIM_InitStructure.TIM_Polity    = PolityHigh;			//interrupt priority, PolityHigh,PolityLow
	TIM_InitStructure.TIM_Interrupt = ENABLE;				//interrupt enable,   ENABLEDISABLE
	TIM_InitStructure.TIM_ClkSource = TIM_CLOCK_12T;			//timer source,    TIM_CLOCK_1T,TIM_CLOCK_12T,TIM_CLOCK_Ext
	TIM_InitStructure.TIM_ClkOut    = ENABLE;				//use fast pulse, ENABLEDISABLE
	TIM_InitStructure.TIM_Value     = 65536UL - PWM_HIGH_MIN_TIME;	//init value
	TIM_InitStructure.TIM_Run       = ENABLE;				//enable timer, ENABLEDISABLE
	Timer_Inilize(Timer0,&TIM_InitStructure);				// init Timer0	  Timer0,Timer1,Timer2
}

void led_init()
{
	P1M1 &= ~(1 << 1);	//P1.1 set to output
	P1M0 |=  (1 << 1);
}
void led_on()
{
	P11 = 1;
}
void led_off()
{
	P11 = 0;
}
void pca_pwm_init()
{
	P2M1 &= ~(0xe0);	//P2.7 P2.6 P2.5 set to output
	P2M0 |=  (0xe0);

	pwm0 = 2768;	//init pwm
	pwm1 = 2768;
	pwm2 = 2768;

	PWMn_Update(PCA0,pwm0);
	PWMn_Update(PCA1,pwm1);
	PWMn_Update(PCA2,pwm2);

}

void router_init()
{
 	P2M1 &= ~(1 << 2);	//P2.2 set to output
	P2M0 |=  (1 << 2);
}
void router_open()
{
	P22 = 0; //turn on router
}
void router_close()
{
 	P22 = 1; //turn off router
}

void get_message()	   //get messages
{
	if(COM1.RX_TimeOut > 0)        //if time out
	{
		//UART
		if(--COM1.RX_TimeOut == 0)  //set enough time
		{
			if(COM1.RX_Cnt > 0)
			{
				if(RX1_Buffer[0]=='#')
				{
					communicate_time = 0;  //reset flag 
						switch(RX1_Buffer[1]){
							case'0':
							   // led_test(10);
								message_p[0]=strtok(RX1_Buffer,delim);
								message_p[0]=strtok(NULL,delim);
								message_p[1]=strtok(NULL,delim);
								message_p[2]=strtok(NULL,delim);
								message_p[3]=strtok(NULL,delim);

								message_data[0] = atoi(message_p[0]);
								message_data[1] = atoi(message_p[1]);
								message_data[2] = atoi(message_p[2]);
								message_data[3] = atoi(message_p[3]);
							break;
							case '2':
							break;
							case '3':
							break;
							case '4':
							break;
							default:
							break;
						}
					}	
				}
				COM1.RX_Cnt = 0;
			}	
		}

}
/**********************************************/
void main(void)
{		
	led_init();			 //LED set to output
	led_off();		     //LED turn off

	router_init();		//router set to output
	router_close();		//close router
	router_open();		//open router

	UART_config();		//UART init

	PCA_config();		//PWM init
	pca_pwm_init();		//PWM set to output
	
	//TIME_PWM test
	P_PWM = 0;
	P3M1 &= ~(1 << 5);	//P3.5 set to output
	P3M0 |=  (1 << 5);

	Timer_config();

	pwm = 2768;	//set a init value for PWM, %10 duty cycle
	LoadPWM(pwm);

	EA = 1;					    //init interrupt

	while (1)
	{
		delay_ms(1);
		if(++communicate_time > 500)  //Increase each loop, when bigger than 500, it will regard as communication interrupt
		{
			//failsafe
			message_data[0]=1500;
			message_data[1]=1500;
			message_data[2]=1500;
			message_data[3]=1500;
			if(communicate_time==60000)//lost control
			{
				led_on();//turn on LED
			}
			else
			{
				led_off();//turn off LED
			}
		}
		get_message();  //get messages

		/*
		*   PWM calculation
		*
		*   924+3.68*(1000-1000)       	  924             0.5
		* -----------------------   = -------------  = ---------
		*           36874		         36874             20
		*
		*   924+3.68*(1500-1000)       	  2764            1.5
		* -----------------------   = -------------  = ---------
		*           36874		         36874             20
		*
 		*   924+3.68*(2000-1000)       	  4604            2.5
		* -----------------------   = -------------  = ---------
		*           36874		         36874             20
		*
		*/
		//message_data[0] is steering,message_data[1] is throttle

		//pwm2 connected to GL-MOTO-Mini's PWM1,the timmer is pwm2pin is P2.7
		//PWM1 full cycle
		pwm2 = 924+3.68*(message_data[1]-1000);//20ms duty cycle 0.5~2.5
		if(pwm2 >= PWM_HIGH_MAX_PCA)	pwm2 = PWM_HIGH_MIN_PCA;
		PWMn_Update(PCA2,pwm2);

		//PWM1 half cycle
		//pwm2 = 1843+1.85*(message_data[1]-1000);//20ms duty cycle 1~2
		//if(pwm2 >= PWM_HIGH_MAX_PCA)	pwm2 = PWM_HIGH_MIN_PCA;
		//PWMn_Update(PCA2,pwm2);

		//pwm1 connected to GL-MOTO-Mini's PWM2,timer is pwm1pin is P2.6
		//PWM1 full cycle
		pwm1 = 924+3.68*(2000-(message_data[0]));	//20ms duty cycle 0.5~2.5
		if(pwm1 >= PWM_HIGH_MAX_PCA)	pwm1 = PWM_HIGH_MIN_PCA;
		PWMn_Update(PCA1,pwm1);

		//PWM2 half cycle
		//pwm1 = 1843+1.85*(message_data[0]-1000);//20ms duty cycle 1~2
		//if(pwm1 >= PWM_HIGH_MAX_PCA)	pwm1 = PWM_HIGH_MIN_PCA;
		//PWMn_Update(PCA1,pwm1);

		//pwm0 is connected to GL-MOTO-Mini's PWM3, timer is pwm0 pin is P2.5
		//PWM3 full cycle
		pwm0 = 924+3.68*(message_data[0]-1000);//20ms duty cycle 0.5~2.5
		if(pwm0 >= PWM_HIGH_MAX_PCA)	pwm0 = PWM_HIGH_MIN_PCA;
		PWMn_Update(PCA0,pwm0);

		//PWM3 half cycle
		//pwm0 = 1843+1.85*(message_data[0]-1000);//20ms duty cycle 1~2
		//if(pwm0 >= PWM_HIGH_MAX_PCA)	pwm0 = PWM_HIGH_MIN_PCA;
		//PWMn_Update(PCA0,pwm0);
	
		pwm = 924+3.68*(message_data[0]-1000);//20ms duty cycle 1~2
		if(pwm >= PWM_HIGH_MAX_TIME)	pwm = PWM_HIGH_MAX_TIME;
		LoadPWM(pwm);

		//pwm = 1843+1.85*(message_data[0]-1000);//20ms duty cycle 1~2
		//if(pwm >= PWM_HIGH_MAX_TIME)	pwm = PWM_HIGH_MAX_TIME;
		//LoadPWM(pwm);	
	}
}



